#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <rpc.h>

#include "pgpPubTypes.h"
#include "pgpErrors.h"
#include "pgpFileSpec.h"
#include "pgpUtilities.h"
#include "pgpKeys.h"

#include "../pgpkeysvc.h"
#include "pgpmsg.h"

PGPError pgprpc_OpenKeyDB(PFLFileSpecRef pub, PFLFileSpecRef sec, PGPFlags flags);
void printKeys( PGPKeyDBRef *keydb_ref, const char *prefix, FILE *fout );

int main(int argc, char **argv)
{
	PGPKeySetRef keys;
	PGPError err;
	PGPContextRef context;
	PGPMemoryMgrRef	memoryMgr;

	PFLFileSpecRef FileSpecRef;

	if (init_pgp_rpc()) {
		printf("init_pgp_rpc() fails\n");
		exit(1);
	}
	printf("Connected.\n");

	err = PGPsdkInit( 0);
	if ( IsPGPError( err ) ) {
		printf ("Initialization error: %d\n", err );
		exit(1);
	}
	
	err	= PGPNewContext( kPGPsdkAPIVersion, &context );
	if ( IsPGPError( err ) ) {
		printf("PGPNewContext() fails\n");
		exit(1);
	}

	memoryMgr = PGPPeekContextMemoryMgr(context);

	PFLNewFileSpecFromFullPath(memoryMgr, "D:\\temp\\pubring.pkr", &FileSpecRef);
	if (IsPGPError (err))
		return err;

	pgprpc_OpenKeyDB(FileSpecRef, FileSpecRef, 0, err);

//	printKeys(keydb_ref, "  ", stdout);

	uninit_pgp_rpc();
    return 0;
}
